---
title: Firewall events · Cloudflare Logs docs
description: The descriptions below detail the fields available for firewall_events.
lastUpdated: 2025-07-25T16:42:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/firewall_events/
  md: https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/firewall_events/index.md
---

The descriptions below detail the fields available for `firewall_events`.

## Action

Type: `string`

The code of the first-class action the Cloudflare Firewall took on this request.\
Possible actions are *unknown* | *allow* | *block* | *challenge* | *jschallenge* | *log* | *connectionclose* | *challengesolved* | *challengebypassed* | *jschallengesolved* | *jschallengebypassed* | *bypass* | *managedchallenge* | *managedchallengenoninteractivesolved* | *managedchallengeinteractivesolved* | *managedchallengebypassed*.

## ClientASN

Type: `int`

The ASN number of the visitor.

## ClientASNDescription

Type: `string`

The ASN of the visitor as string.

## ClientCountry

Type: `string`

Country from which request originated.

## ClientIP

Type: `string`

The visitor's IP address (IPv4 or IPv6).

## ClientIPClass

Type: `string`

The classification of the visitor's IP address, possible values are: *unknown* | *badHost* | *searchEngine* | *allowlist* | *monitoringService* | *noRecord* | *scan* | *tor*.

## ClientRefererHost

Type: `string`

The referer host.

## ClientRefererPath

Type: `string`

The referer path requested by visitor.

## ClientRefererQuery

Type: `string`

The referer query-string was requested by the visitor.

## ClientRefererScheme

Type: `string`

The referer URL scheme requested by the visitor.

## ClientRequestHost

Type: `string`

The HTTP hostname requested by the visitor.

## ClientRequestMethod

Type: `string`

The HTTP method used by the visitor.

## ClientRequestPath

Type: `string`

The path requested by visitor.

## ClientRequestProtocol

Type: `string`

The version of HTTP protocol requested by the visitor.

## ClientRequestQuery

Type: `string`

The query-string was requested by the visitor.

## ClientRequestScheme

Type: `string`

The URL scheme requested by the visitor.

## ClientRequestUserAgent

Type: `string`

Visitor's user-agent string.

## ContentScanObjResults

Type: `array[string]`

List of content scan results.

## ContentScanObjSizes

Type: `array[int]`

List of content object sizes.

## ContentScanObjTypes

Type: `array[string]`

List of content types.

## Datetime

Type: `int or string`

The date and time the event occurred at the edge.

## Description

Type: `string`

The description of the rule triggered by this request.

## EdgeColoCode

Type: `string`

The airport code of the Cloudflare data center that served this request.

## EdgeResponseStatus

Type: `int`

HTTP response status code returned to browser.

## Kind

Type: `string`

The kind of event, currently only possible values are: *firewall*.

## LeakedCredentialCheckResult

Type: `string`

Result of the check for [leaked credentials](https://developers.cloudflare.com/waf/detections/leaked-credentials/).\
Possible results are: *password\_leaked* | *username\_and\_password\_leaked* | *username\_password\_similar* | *username\_leaked* | *clean*.

## MatchIndex

Type: `int`

Rules match index in the chain. The last matching rule will have MatchIndex *0*. If another rule matched before the last one, it will have MatchIndex *1*. The same applies to any other matching rules, which will have a MatchIndex value of *2*, *3*, and so on.

## Metadata

Type: `object`

Additional product-specific information. Metadata is organized in key:value pairs. Key and Value formats can vary by Cloudflare security product and can change over time.

## OriginResponseStatus

Type: `int`

HTTP origin response status code returned to browser.

## OriginatorRayID

Type: `string`

The RayID of the request that issued the challenge/jschallenge.

## RayID

Type: `string`

The RayID of the request.

## Ref

Type: `string`

The user-defined identifier for the rule triggered by this request. Use refs to label your rules individually alongside the Cloudflare-provided RuleID. You can set refs via the [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/) for some security products.

## RuleID

Type: `string`

The Cloudflare security product-specific RuleID triggered by this request.

## Source

Type: `string`

The Cloudflare security product triggered by this request.\
Possible sources are *unknown* | *asn* | *country* | *ip* | *iprange* | *securitylevel* | *zonelockdown* | *waf* | *firewallrules* | *uablock* | *ratelimit* | *bic* | *hot* | *l7ddos* | *validation* | *botfight* | *apishield* | *botmanagement* | *dlp* | *firewallmanaged* | *firewallcustom* | *apishieldschemavalidation* | *apishieldtokenvalidation* | *apishieldsequencemitigation*.
